/***************************************************************************

  osdepend.c

  OS dependant stuff (display handling, keyboard scan...)
  This is the only file which should me modified in order to port the
  emulator to a different system.

***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gpdef.h"
#include "gpstdio.h"
#include "gpstdlib.h"
#include "gpgraphic.h"
#include "gpfont.h"
#include "gpmem.h"
#include "driver.h"
#include "gp32_mame.h"
#include "gp32_menu.h"

int  msdos_init_seal (void);
int  msdos_init_sound(void);
void msdos_init_input(void);
void msdos_shutdown_sound(void);
void msdos_shutdown_input(void);

/* platform independent options go here */
struct GameOptions options;

/* enablecache.o */
extern void EnableCache(void);

/* Command Line Arguments Emulation */
int argc=2;
char *argv[] = {"mame","builtinn"};

/* put here anything you need to do when the program is started. Return 0 if */
/* initialization was successful, nonzero otherwise. */
int osd_init(void)
{
	gp32_text_log("GP32 Port Init...");
	msdos_init_seal();
	if (msdos_init_sound())
		return 1;
	msdos_init_input();
	return 0;
}


/* put here cleanup routines to be executed when the program is terminated. */
void osd_exit(void)
{
	msdos_shutdown_sound();
	msdos_shutdown_input();
}


/* Get Command Line Options */
static __inline void parse_cmdline (int myargc, char **myargv, struct GameOptions *options, int game_index)
{
	/* from sound.c */
	extern int soundcard;

	/* from gp32_menu.c */
	extern int gp32_frameskip;
	extern int gp32_sound;
	extern int gp32_freq;

	/* From video.c */
	extern int gp32_new_gfx_core;
	
	options->frameskip = gp32_frameskip; /* 0,1,2,3... */
	options->norotate  = 0;
	options->ror       = gp32_new_gfx_core; /* Better for GP32 screen */
	options->rol       = 0;
	options->flipx     = 0;
	options->flipy     = 0; 

	/* read sound configuration */
	soundcard=gp32_sound; /* 1 sound, 0 not emulated sound, 2 no sound but emulated, 3=accurate (22050), 4=accurate (11025) */

#if 0
	extern int use_emulated_ym3812;
	use_emulated_ym3812=1; /* This was for PCs with Soundblaster cards that have ym3812 chips */
#endif
	options->samplerate = 11025;	/* default rate, updated by sound.c later */
	options->samplebits = 8;

	/* misc configuration */
	options->cheat = 0;		/* should be a menu option */
}


void gpClockSpeedChange(int freq, int magic, int div)
{
	#define rTCFG0          (*(volatile unsigned *)0x15100000)
	#define rTCFG1          (*(volatile unsigned *)0x15100004)
	#define rTCNTB4         (*(volatile unsigned *)0x1510003c)
	unsigned int pclk;
	unsigned int prescaler0;
	
	/* Change CPU Speed */
	GpClockSpeedChange(freq, magic, div);
	pclk = GpPClkGet();

	/* Repair SDK timer - it forgets to set prescaler */
	prescaler0 = (pclk/(8000*40))-1;
	rTCFG0 = (rTCFG0&0xFFFFFF00)|prescaler0;
	rTCFG1 = 0x30033;

	/* Repair GpTickCountGet */
	rTCNTB4 = pclk/1600;
}


void GpMain(void *arg)
{
	/* From gp32_menu.c */
	extern int gp32_freq;

	char text[64];
	int res, i, j, game_index;

	/* CPU Alignment Cache */
	EnableCache();

	/* SMC Access Init */
 	GpFatInit();

	/* Clock Speed 133 mhz */
	gpClockSpeedChange(132000000, 0x3a011, 3);
	
	/* GP32 Video Init */
	gp32_video_init();

	/* Show Intro Screen */
	intro_screen();

	/* Initialize Game Listings */
 	game_list_init();

	while(1) {

		/* Clock Speed 66 MHz */
		gpClockSpeedChange(67500000,0x25002,2);
		
		/* GP32 Video Init */
		gp32_video_init();

		/* Select Game */
		select_game(argv);

		/* Select Clock Speed */
		switch(gp32_freq) {
			case 66: /* Clock Speed 66 mhz */
				GpClockSpeedChange(67800000, 0x69032, 3);
				break;
			case 80: /* Clock Speed 80 mhz */
				GpClockSpeedChange(80000000, 0x48012, 1);
				break;
			case 100: /* Clock Speed 102 mhz */
				GpClockSpeedChange(102000000, 0x1a020, 2);
				break; 
			case 133: /* Clock Speed 133 mhz */
				gpClockSpeedChange(132000000, 0x3a011, 3);
				/*192 gpClockSpeedChange(132000000, 0x38001, 3);*/
				/*177 gpClockSpeedChange(132000000, 0x34001, 3);*/
				break;
			case 144: /* Clock Speed 144 mhz */
 				gpClockSpeedChange(140000000, 0x3e011, 3);
				break;
			case 150: /* Clock Speed 150 mhz */
 				gpClockSpeedChange(150000000, 0x43011, 3);
				break;
			case 156: /* Clock Speed 156 mhz */
				gpClockSpeedChange(156000000, 0x46011, 3);
				break;
			case 160: /* Clock Speed 160 mhz */
 				gpClockSpeedChange(160000000, 0x48011, 3);
				break;
			case 166: /* Clock Speed 166 mhz */
				gpClockSpeedChange(166000000, 0x4b011, 3); 
				break;
			case 168: /* Clock Speed 168 mhz */
				gpClockSpeedChange(168000000, 0x14000, 3); 
				break;
			case 172: /* Clock Speed 172 mhz */
				gpClockSpeedChange(172000000, 0x23010, 3); 
				break;
			case 176: /* Clock Speed 176 mhz */
				gpClockSpeedChange(176000000, 0x24010, 3); 
				break;
			case 180: /* Clock Speed 180 mhz */
				gpClockSpeedChange(180000000, 0x16000, 3); 
				break;
			case 184: /* Clock Speed 184 mhz */
				gpClockSpeedChange(184000000, 0x26010, 3); 
				break;
			case 188: /* Clock Speed 188 mhz */
				gpClockSpeedChange(188000000, 0x27010, 3); 
				break;
			case 192: /* Clock Speed 192 mhz */
				gpClockSpeedChange(192000000, 0x18000, 3); 
				break;
			case 196: /* Clock Speed 196 mhz */
				gpClockSpeedChange(196000000, 0x29010, 3); 
				break;
			case 200: /* Clock Speed 200 mhz */
				gpClockSpeedChange(200000000, 0x2A010, 3); 
				break;
			case 204: /* Clock Speed 204 mhz */
				gpClockSpeedChange(204000000, 0x2b010, 3); 
				break;
			case 208: /* Clock Speed 208 mhz */
				gpClockSpeedChange(208000000, 0x2c010, 3); 
				break;
			case 212: /* Clock Speed 212 mhz */
				gpClockSpeedChange(212000000, 0x2d010, 3); 
				break;
			case 216: /* Clock Speed 216 mhz */
				gpClockSpeedChange(216000000, 0x2e010, 3); 
				break;
			case 220: /* Clock Speed 220 mhz */
				gpClockSpeedChange(220000000, 0x2f010, 3); 
				break;
			case 224: /* Clock Speed 224 mhz */
				gpClockSpeedChange(224000000, 0x30010, 3); 
				break;
			case 228: /* Clock Speed 228 mhz */
				gpClockSpeedChange(228000000, 0x1e000, 3); 
				break;
			case 232: /* Clock Speed 232 mhz */
				gpClockSpeedChange(232000000, 0x32010, 3); 
				break;
			case 236: /* Clock Speed 236 mhz */
				gpClockSpeedChange(236000000, 0x33010, 3); 
				break;
			case 240: /* Clock Speed 240 mhz */
				gpClockSpeedChange(240000000, 0x20000, 3); 
				break;
			case 244: /* Clock Speed 244 mhz */
				gpClockSpeedChange(244000000, 0x35010, 3); 
				break;
			case 248: /* Clock Speed 248 mhz */
				gpClockSpeedChange(248000000, 0x36010, 3); 
				break;
			case 252: /* Clock Speed 252 mhz */
				gpClockSpeedChange(252000000, 0x22000, 3); 
				break;
			case 256: /* Clock Speed 256 mhz */
				gpClockSpeedChange(256000000, 0x38010, 3); 
				break;
		}
		
		/* GP32 Video Init */
		gp32_video_init();

		/* Initialize the audio library */
		/* msdos_init_seal(); */
		
		/* Restore MAME Palette */
		gp32_mame_palette();
		
		/* Set Log Messages start at row 0 */
		gp32_gamelist_zero();
		
		/* take the first commandline argument without "-" as the game name */
		for (j = 1; j < argc; j++)
			if (argv[j][0] != '-') break;
	
		gm_lowercase(argv[j],gm_lstrlen(argv[j]));
		game_index = -1;
	
		/* do we have a driver for this? */
		for (i = 0; drivers[i] && (game_index == -1); i++)
		{
			/*if (strcasecmp(argv[j],drivers[i]->name) == 0)*/
			if (gm_compare(argv[j],drivers[i]->name) == 0)
			{
				game_index = i;
				break;
			}
		}
	
		if (game_index == -1)
		{
			gm_sprintf(text,"Game \"%s\" not supported\0",argv[1]);
			gp32_text_log(text);
			while(GpKeyGet()!=GPC_VK_NONE) { }
			while(GpKeyGet()==GPC_VK_NONE) { }
		}

		/* parse generic (os-independent) options */
		parse_cmdline (argc, argv, &options, game_index);
	
		{	/* Mish:  I need sample rate initialised _before_ rom loading for optional rom regions */
			extern int soundcard;

			if (soundcard == 0) {    /* silence, this would be -1 if unknown in which case all roms are loaded */
				Machine->sample_rate = 0; /* update the Machine structure to show that sound is disabled */
				options.samplerate=0;
			}
		}

		gm_sprintf(text,"Loading \"%s\"...",drivers[game_index]->description);
		gp32_text_log(text);
	
		/* go for it */
		res = run_game (game_index , &options);
		
		/* Error? */
		if( res != 0 )
		{
			gp32_text_log("LOAD FAILED: Press any key to continue.");
			while(GpKeyGet()!=GPC_VK_NONE) { }
			while(GpKeyGet()==GPC_VK_NONE) { }
		}

	} /* MAME never ends xD */
}
